define([
    'underscore',
    'backbone',
    'marionette',
    'json!featureFlagJson',
    'app',
], function (
    _,
    Backbone,
    Marionette,
    FeatureFlagJson,
    App
) {
    'use strict';
    
    
    describe('Eligibility API integration feature flag', function() {
        
        it('If feature flag is enabled in JSON, then verify function returns accordingly ', function() {
            // test set up
            var jsonModel = new Backbone.Model(FeatureFlagJson);// mock JSON file
            var flagExists = jsonModel.has('CC_ELIG_SERVICE_DISABLED'); // confirm json has right name for flag
            var eligServiceDisabled = jsonModel.get('CC_ELIG_SERVICE_DISABLED');
            
            var result = App.isCcEligFeatureEnabled();
            if (flagExists) {
                expect(result).toEqual(!eligServiceDisabled);
            } else {
                expect(result).toEqual(false);
            }
        });
        
    });
});
